<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\BannerGroups;
use Mnv\Models\Banners;

/**
 * Class BannerAdmin
 * @package Mnv\Admin\Controllers
 */
class BannerAdmin extends AdminMnv
{

	public function fetch()
    {

        $bannerImage = new Banners($this->request);
        $image    = $this->request->get('image', '');
        $imageId = (int) $this->request->get('imageId');

        $this->smarty->assign('activeItem','banners');
        $this->smarty->assign('title', 'Банер');
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        $this->smarty->assign('groups', BannerGroups::getGroups());


        if ($this->action == 'add' || $this->action == 'edit') {

            $bannerImage->edit()->getFiles()->gettingInfoAboutUsers();


        } else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($bannerImage->data['title'])) $this->errors['title'] = true;
            if (empty($bannerImage->data['groupId'])) $this->errors['group'] = true;

//            if (!empty($image)) $bannerImage->data['fileId'] = $image['fileId'];
            if (!empty($image['fileId'])) $images['fileId'] = $image['fileId'];

            if (empty($this->errors)) {
                if ($bannerImage->prepare($bannerImage->data, $this->manager['userId'])) {
                    if (!empty($images['fileId'])) $bannerImage->addMainImage($bannerImage->id, $images);
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $bannerImage->edit()->getFiles()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/banners?" . $this->buildQueryString(['page' => $this->page]));
            }

        } else if ($this->action == 'deleteImage') {

            $result = $bannerImage->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        $this->smarty->assign('banner',  $bannerImage->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('banners')) {
            return $this->smarty->fetch('views/banners/banner.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}