<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Shop\Currencies;

/**
 * Class CurrencyAdmin
 * @package Mnv\Admin\Controllers
 */
class CurrencyAdmin extends AdminMnv
{

    public function fetch()
    {

        $currency = new Currencies($this->request);

        $this->smarty->assign('activeItem','currencies');
        $this->smarty->assign('title', lang('currency:title'));


        if ($this->action == 'add' || $this->action == 'edit') {

            $currency->edit()->gettingInfoAboutUsers();

        }
        else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($currency->data['title'])) $this->errors['titleNull'] = true;
            if (empty($currency->data['codeName'])) $this->errors['codeNameNull'] = true;

            if (empty($currency->data['course'])) $this->errors['course'] = true;

            if (empty($this->errors)) {
                if ($currency->prepare($currency->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }

                if (!saveSerializations()) $this->errors['serializations'] = true;
            }

            $currency->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->adminUrl . '/currencies');
            }

        }

        $this->smarty->assign('currency', $currency->data);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('currencies')) {
            return $this->smarty->fetch('views/currencies/currency.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }
}


    



