<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Models\Shop\Colors;


/**
 * Class ProductColorAdmin
 * @package Mnv\Admin\Controllers
 */
class ProductColorAdmin extends AdminMnv
{
    /**
     * @var string
     */
    private $typeContent;

    public function fetch()
    {
        $colors = new Colors($this->request);

        $this->typeContent   = $this->module .'s';

        $this->smarty->assign('activeItem', $this->typeContent);
        $this->smarty->assign('title', 'Цвета');
        /* statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module . 's');

        if ($this->action == 'add' || $this->action == 'edit') {
            $colors->edit();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($colors->data['colorName'])) $this->errors['title'] = true;

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                if ($colors->prepare($colors->data, $this->module, $this->manager['userId'])) {
                    $this->messages['saved'] = true;

                } else {
                    $this->errors['not_saved'] = true;
                }

            }

            $colors->edit();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/" . $this->typeContent . "?" . $this->buildQueryString(['page' => $this->page]));
            }

        }

//        if (!empty($colors->id)) {
//            $colors->data['articleIds'] = $colors->getSelectedModels($colors->id);
//        }

        $this->smarty->assign('color', $colors->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions($this->module.'s')) {
            return $this->smarty->fetch('views/shop/' . $this->module .'.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}