<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {capture name="buttons"}
		<button class="btn btn-sm btn-primary me-2" type="submit" name="action" value="save"><i class="ph-floppy-disk me-2"></i> {general:save}</button>
		<a class="btn btn-sm btn-light" href="{$adminUrl}/ads">{general:cancel}</a>
    {/capture}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/ads" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <!-- Content area -->
    <div class="content">
    
        <div class="row"> 
            <div class="col-md-8">

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:general}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
			            <div class="card-body">
	                        {if isset($error.fileType)}<p class="text-center text-danger">{$l.banners.errorFileType}</p>{/if}
		                    <div class="row">
			                    <div class="col-md-12 mb-3">
				                    <div class="form-check mb-2">
					                    <input type="checkbox" class="form-check-input" id="isActive" name="banner[isActive]" value="1" {if isset($banner.isActive)}checked{/if}>
					                    <label class="form-check-label" for="isActive">{banners:isActive}</label>
				                    </div>
			                    </div>

			                    <div class="col-md-12">
				                    <div class="form-group mb-3">
			                            <label class="form-label is-visible {if isset($errors.bannerName)}text-danger{/if}">{banners:bannerName}</label>
			                            <input type="text" class="form-control" name="banner[bannerName]" value="{$banner.bannerName|escape|default:""}">
			                        </div>
			                    </div>
			                    <div class="col-md-12">
				                    <div class="form-group mb-3">
			                            <label class="form-label is-visible">{banners:bannerUrl}</label>
			                            <input class="form-control" type="text" name="banner[bannerUrl]" value="{$banner.bannerUrl|escape|default:""}" placeholder="http://" />
			                        </div>
			                    </div>
			                    <div class="col-md-12">
				                    <div class="form-group mb-3">
			                            <label class="form-label is-visible">{banners:alternativeText}</label>
			                            <input class="form-control" type="text" name="banner[alternativeText]" value="{$banner.alternativeText|escape|default:""}" />
			                        </div>
			                    </div>
		                    </div>
	                    </div>
		            </div>
    		    </div>

            </div>
    
            <div class="col-md-4">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">Баннер</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
				        <div class="card-body">
					        {if isset($banner.generatedCode)}{$banner.generatedCode nofilter}{/if}
				        </div>
				        <div class="card-footer hstack gap-3 justify-content-between">
					        <div class="text-muted">
						        <div class="form-group">
							        <input type="file" class="file-input" name="file" title="{banners:selectFile}"
							               data-show-caption="false"
							               data-show-upload="false"
							               data-browse-class="btn btn-primary"
							               data-remove-class="btn btn-light" data-fouc>
						        </div>
					        </div>
					        <div class="hstack gap-1">
					        </div>
				        </div>
			        </div>
    			</div>

            </div>


	        <div class="col-md-12 text-center">
		        <input type="hidden"  name="banner[bannerId]" value="{$banner.bannerId|default:""}" />
		        <input type="hidden"  name="banner[bannerWidth]" value="{$banner.bannerWidth|default:""}" />
		        <input type="hidden"  name="banner[bannerHeight]" value="{$banner.bannerHeight|default:""}" />
		        <input type="hidden"  name="banner[bannerType]" value="{$banner.bannerType|default:""}" />
		        <input type="hidden"  name="banner[fileUrl]" value="{$banner.fileUrl|default:""}" />

		        {$smarty.capture.buttons nofilter}
	        </div>
        </div>
    </div>

</form>

{if isset($bannerDeleted)}
	<p align="center">{$l.banners.deleted}</p>
{elseif isset($bannerSaved)}
	<p align="center">{$l.banners.saved}</p>
{/if}


<script>
  	
    $(document).ready(function () { 
        {if isset($errors.access_denied)} new Noty({ text: '{banners:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{banners:errors:0}', type: 'error', timeout: 1500 }).show();  {/if}
        {if isset($errors.fileType)} new Noty({ text: '{$l.banners.errorFileType}', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($errors.bannerName)} new Noty({ text: '{banners:errors:2}', type: 'error', timeout: 1500 }).show(); {/if}
        
        {if isset($messages.saved)} new Noty({ text: '{banners:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
        {if isset($messages.deleted)} new Noty({ text: '{banners:messages:1}', type: 'success', timeout: 1500 }).show(); {/if}
    });           
</script>
