
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-primary fn_add_coupon" data-popup="popover-solid" data-trigger="hover" title="{general:add}" data-placement="top" href="javascript:void('')"><i class="icon-plus3"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/coupons" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/coupons"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card">
				<div class="">
					<table class="table table-xs table-striped table-hover table-xl" id="coupons">
						<thead>
						<tr>
							<th data-toggle="true" class="text-nowrap">Название купона</th>
							<th data-hide="phone" class="text-center text-nowrap">Скидка</th>
							<th data-hide="phone" class="text-center text-nowrap">Условия</th>
							<th data-hide="phone" class="text-center text-nowrap">Срок действия</th>
							<th data-hide="phone" class="text-center text-nowrap">Одноразовый</th>
							<th data-hide="phone" class="text-center text-nowrap">Кол-во использований</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if isset($coupons)}
							<tbody class="selectable-demo-list fn_coupon_wrap" id="fn_new_coupon">

							<tr class="new_coupon fn_new_coupon">
								<td width="30%" class="text-left"><input type="text" id="code" name="code" class="form-control" placeholder="Название купона" value=""></td>
								<td class="text-center">
									<div class="input-group">
										<input type="text" id="value" name="value" class="form-control" placeholder="Скидка" value="">
										<select id="type" name="couponType" class="form-control  select-types" data-width="100">
											<option value="percentage">%</option>
											<option value="absolute">{$defaultCurrency}</option>
										</select>
									</div>
								</td>
								<td class="text-center"><input type="text" id="min_order_price" name="min_order_price" class="form-control" placeholder="Сумма заказа" value=""></td>
								<td class="text-center"><input type="text" id="expire" name="expire" class="form-control daterange-single" placeholder="Срок действия"></td>
								<td class="text-center single" width="30">
									<select id="single" name="single" class="form-control select-types">
										<option value="0">Нет</option>
										<option value="1">Да</option>
									</select>
								</td>

								<td colspan="2" class="text-right text-nowrap"><button class="btn btn-sm btn-primary mr-2 new_coupon_button" type="submit" name="action" value="apply"><i class="ph-check me-2"></i> {general:apply}</button></td>
							</tr>

                            {foreach item=coupon from=$coupons name=coupons}
								<tr id="coupon-{$coupon.couponId}" data-id="{$coupon.couponId}">
                                    {*                            <td class="text-center text-nowrap"><input type="checkbox" name="coupon[couponId]" value="{$coupon.couponId}" class="form-input-styled" data-fouc> </td>*}
									<td width="30%" class="text-left">{$coupon.code|escape}</td>
									<td class="text-center">
                                        {if $coupon.type eq 'percentage'}{$coupon.value|number_format:0:".":" "}%{else}{$coupon.value|number_format:0:".":" "} {$defaultCurrency}{/if}
									</td>
									<td class="text-center">{if $coupon.type eq 'absolute'}Для заказов от <br />{$coupon.min_order_price|number_format:0:".":" "} {$defaultCurrency} {/if}</td>
									<td class="text-center">{if !is_null($coupon.expire)}Действует до <br />{$coupon.expire|escape}{else}<span class="icon-infinite"></span>{/if}</td>
									<td class="text-center">{if $coupon.single eq 1}ДА{/if}</td>
									<td class="text-center" width="30">{$coupon.usages|escape}</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<button class="btn btn-link text-danger" onclick="newRemove({$coupon.couponId}, '{$coupon.code|escape}', 'coupons');"><i class="ph-trash"></i></button>
										</div>
									</td>

								</tr>
                            {/foreach}
							</tbody>
                            {if isset($pageNums) && $pageNums > 0}
								<tfoot><tr><td colspan="8" class="text-left"><div class="">{general:results}</div></td></tr></tfoot>
                            {/if}
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function () {
        {if isset($errors.not_saved)} new Noty({ text: '{sliders:errors:3}', type: 'error' }).show(); {/if}
        {if isset($errors.slider_not_found)} new Noty({ text: '{sliders:errors:6}', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: '{sliders:messages:0}', type: 'success' }).show(); {/if}

    });

    $(function() {
        var new_coupon = $(".fn_new_coupon").clone();
        $(".fn_new_coupon").remove();
        $(document).on("click", ".fn_add_coupon", function () {
            $(this).remove();
            $(".fn_coupon_wrap").prepend(new_coupon);
            // $('.fn_new_coupon .pickadate').pickadate({ format: 'yyyy-mm-dd' });
            // $('.fn_new_coupon select').select2({ minimumResultsForSearch: -1 });
        });

        $(document).on("click", ".new_coupon_button" , function() {
            var code = $('input[name=code]').val(), value = $('input[name=value').val(),
                type = $('select[name=couponType]').val(),
                min_order_price = $('input[name=min_order_price]').val(),
                expire = $('input[name=expire]').val(),
                single = $('select[name=single]').val();

            if (typeof code !== "undefined" && typeof value !== "undefined") {
                $.post('{$adminUrl}/coupons?action=apply', { "coupon[code]": code, "coupon[value]": value, "coupon[type]": type, "coupon[min_order_price]": min_order_price, "coupon[expire]": expire, "coupon[single]": single}, function (response) {
                    if (response.status === 200) {
                        new Noty({ text: 'Купон добавлен', layout: 'topRight', type: 'success', timeout: 1500 }).show();
                    } else {
                        new Noty({ text: 'Ошибка при добавление купона', layout: 'topRight', type: 'error', timeout: 1500 }).show();
                    }
                    $.each( response.message, function( key, value ) {
                        $('#' + key).addClass('error').css('border-color', '#ec0000')
                    });
                }, 'json');
            }


        });
    });


</script>


