
	<!-- Page header -->
	{capture name="buttons"}
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/orders" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
	                {include file="views/stats/form/selectors.tpl" action="" select=''}
				</div>

				<div class="card border shadow-sm">
					<div class="">
						<table class="table table-xs table-togglable table-striped table-hover" id="orders">
							<thead>
							<tr>
								<th class="text-center text-nowrap" width="30">№ Заказа</th>
								<th class="text-left">Дата заказа</th>
								<th class="text-center text-nowrap">Способ оплаты</th>
								<th class="text-center">На сумму</th>
								<th class="text-center">Статус</th>
								<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
							</tr>
							</thead>
							{if $orders}
								<tbody>
			                    {foreach item=order from=$orders name=orders}
									<tr id="order-{$order.order_id}" data-id="{$order.order_id}">
										<td class="text-center">{$order.order_id}</td>

										<td class="text-left text-nowrap">{$order.createdBy}</td>
										<td class="text-center text-nowrap"><img src="{$GLOBAL_URL}/payment/{$order.payment_method|lower}/logo.png" alt="{$order.payment_method|lower}" style="width: 60px"></td>
										<td class="text-nowrap">{if $order.amount ne 0}{$order.amount} сум.{/if}</td>
										<td class="text-center text-nowrap">{$order.statusName}</td>
										<td class="text-center">
											<div class="d-inline-flex">

												<a class="text-primary" href="{$adminUrl}/orderinfo?action=edit&id={$order.order_id}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-arrow-square-out me-2"></i></a>
												<a class="text-primary" href="{$adminUrl}/order?action=edit&id={$order.order_id}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
												<div class="list-icons-item dropdown">
													<a type="button" class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
													<div class="dropdown-menu dropdown-menu-end">
														<a class="dropdown-item" href="{$adminUrl}/order?action=edit&id={$order.order_id}{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i>{general:view}</a>
														<div class="dropdown-divider"></div>
														<button class="dropdown-item text-danger" onclick="newRemove('{$order.order_id}','Заказ №{$order.order_id}', 'orders');"><i class="ph-trash me-2"></i>{general:delete}</button>
													</div>
												</div>
											</div>
										</td>
									</tr>
			                    {/foreach}

								</tbody>
			                {else}
								<tbody><tr class="odd"><td class="text-center" colspan="7">- {general:none} -</td></tr></tbody>
			                {/if}
							</table>
						</table>
					</div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/orders" params="{$buildQueryString}"}
				</div>
			</div>
		</div>

	</div>

	{include file='module/order_init.tpl'}


	<script>

	    $(document).ready(function () {
	        {if isset($messages.saved)} new Noty({ text: '{orders:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
	    });


	</script>







