
	<!-- Page header -->
	{capture name="buttons"}
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/error" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">

				<div class="card border shadow-sm">
					{include file="views/stats/form/selectors.tpl" action='' select=''}
				</div>

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{stats:errorInfo}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<table class="table table-xs table-striped table-actions table-hover">
							<tbody>
								<tr>
									<td class="text-left text-nowrap" width="200">{stats:requestUri}:</td>
									<td class="text-left">
										{if isset($requestUri)}
	{*									<a href="{$requestUri|urldecode|escape}" target="_blank">{$requestUri|urldecode|escape}</a>*}
										<a href="{$requestUri|escape}" target="_blank">{$requestUri|escape}</a>
										{/if}
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<div class="card border shadow-sm">
					<div class="">
						<table class="table table-xs table-striped table-actions table-hover">
							<thead>
								<tr>
									<th>{general:date}</th>
									<th>{stats:referer}</th>
									<th class="text-center text-nowrap">{stats:visitorId}</th>
								</tr>
							</thead>

							{if isset($visits) && !empty($visits)}
							<tbody>
								{foreach item=visit from=$visits name=visits}
									<tr id="visit-{$visit.visitId}">
										<td class="text-start text-nowrap">{$visit.visitDate}</td>
										<td class="text-start" width="100%">{if $visit.referer}<a href="{$visit.referer}" target="_blank">{$visit.referer|truncate:80}</a>{else}{stats:unknown}{/if}</td>
										<td class="text-center text-nowrap"><a href="{$adminUrl}/visitor?visitorId={$visit.visitorId}">{$visit.visitorId}</a></td>

									</tr>
								{/foreach}
							</tbody>
							{else}
								<tbody><tr class="odd"><td class="text-center" colspan="3">- {general:none} -</td></tr></tbody>
							{/if}
						</table>
					</div>
					{include file="module/pagination.tpl" url="{$adminUrl}/error" params="&requestUri={$requestUri}"}
				</div>

			</div>
		</div>
	</div>
