
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-primary mx-1" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/user?action=add{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="icon-plus3"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/users" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/users"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
	<div class="content">

	    <div class="row">

	        <div class="col-md-12">

		        <div class="card border shadow-sm">
{*                    {include file="views/stats/form/selectors.tpl" filter=true url="{$adminUrl}/users" filterDate=false}*}
			        <form action="{$adminUrl}/users" method="post">
				        <div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
					        <div class="mb-0">
						        <div class="input-group">
							        <input type="text" class="form-control" name="query" value="{if isset($query)}{$query}{/if}" autocomplete="off" placeholder="{products:general:searchByName}">
							        <button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
						        </div>
					        </div>

					        <div class="ms-sm-auto">
						        <ul class="list-inline list-inline-condensed mb-0">
							        <li class="list-inline-item">
								        <div class="input-group">
                                            {if isset($statuses) && !empty($statuses)}
                                                {html_options options=$statuses selected=$sts|default:'' name="sts" class="form-control select" onchange="this.form.submit()" data-width="230"}
                                            {/if}

								        </div>
							        </li>
						        </ul>
					        </div>
				        </div>
			        </form>
		        </div>

	            <div class="card border shadow-sm">
		            <div class="">
		                <table class="table table-togglable table-xs table-striped table-hover users-archive" id="users">
		                    <thead>
		                        <tr>
		                            <th data-hide="phone" class="text-center" width="30">{users:table:date}</th>
		                            <th data-hide="image" class="">{users:table:login}</th>
		                            <th data-toggle="true">{users:table:email}</th>
		                            <th data-hide="phone" class="text-center">{general:status}</th>
		                            <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
		                        </tr>
		                    </thead>
		                    {if !empty($users)}
			                    <tbody>
			                        {foreach item=user from=$users name=users}
			                        <tr id="user-{$user.userId}">
			                            <td class="text-center" nowrap="nowrap">{$user.registered nofilter}</td>
				                        <td class="text-nowrap">
					                        <div class="d-flex align-items-center">
						                        <div class="status-indicator-container me-3">
							                        <img src="{if isset($user.image)}{$user.image.medium}{else}/admin/assets/img/no_images.jpg{/if}" class="rounded-circle" width="40" height="40">
							                        <span class="status-indicator {if $user.status eq 1}bg-success{elseif $user.status eq 2 || $user.status eq 3}bg-danger{else}bg-grey{/if} mr-1"></span>
						                        </div>
						                        <div>
							                        <a href="{$adminUrl}/user?action=edit&id={$user.userId}" class="text-body fw-semibold letter-icon-title">{if !empty($user.loginName)}{$user.loginName nofilter}{/if}</a>
							                        <div class="d-flex align-items-center text-muted fs-sm">
	                                                    {$user.last_login|date_format:"%d.%m.%Y %H:%M"}
							                        </div>
						                        </div>
					                        </div>
				                        </td>
			                            <td class="">{$user.email}</td>
			                            <td id="status-{$user.userId}" class="text-center">{$user.statusName nofilter}</td>
			                            <td class="text-center">
			                                <div class="d-inline-flex">
				                                <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/user?action=edit&id={$user.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
			                                    <div class="dropdown">
				                                    <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
			                                        <div class="dropdown-menu dropdown-menu-end">
	                                                    {if $user.status eq 2 or $user.status eq 3}
				                                        <button class="dropdown-item text-danger" id="user-approve-{$user.userId}" onclick="return approve({$user.userId}, 'users');"><i class="ph-handshake me-2"></i> {general:approve}</button>
			                                            {/if}
			                                            <a class="dropdown-item" href="{$adminUrl}/user?action=edit&id={$user.userId}&page={$page}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
			                                            <div class="dropdown-divider"></div>
			                                            <button class="dropdown-item text-danger" onclick="remove({$user.userId}, '{$user.loginName}', 'users')"><i class="ph-trash me-2"></i> {general:delete}</button>
			                                        </div>
			                                    </div>
			                                </div>
			                            </td>
			                        </tr>
			                        {/foreach}

			                    </tbody>
		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
		                    {/if}
		                </table>
		            </div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/users" params="{$buildQueryString}"}

	            </div>
	        </div>

	    </div>
	</div>

	<script>

        function approveSuccess(id) {
            document.getElementById('status-' + id).innerHTML = '{users:statuses:1}';
            document.getElementById('user-approve-' + id).style.display = 'none';
            new Noty({ text: 'Пользователь одобрен', type: 'success', timeout: 1500 }).show();
        }

        function deleteSuccess(id) {
            new Noty({ text: '{users:messages:1}', type: 'success', timeout: 1500 }).show();
            removeElement(id, 'user');
        }

	    function deleteImageMessage() {
	        new Noty({ text: '{users:messages:2}', type: 'success', timeout: 1500 }).show();
	    }
	    function deleteMessage(){
	        new Noty({  text: '{users:messages:1}', type: 'success', timeout: 1500 }).show();
	    }
	    function userNotFound(){
	        new Noty({ text: '{managers:errors:1}', type: 'error' }).show();
	    }
	    function notDeleteAdministrator(){
	        new Noty({ text: '{managers:errors:6}', type: 'error' }).show();
	    }
	    function notDeleteDeveloper(){
	        new Noty({ text: '{managers:errors:14}', type: 'error' }).show();
	    }
	    function notDeleteFound(){
	        new Noty({ text: '{users:errors:17}', type: 'error' }).show();
	    }


	</script>





