<?php

namespace Mnv\Modules;

class Stations
{
    /** @var string */
    private string $table = 'stations';

    /** @var string  */
    private string $table_image = 'station_images';

    /** @var string  */
    private string $primaryKey = 'stationId';

    /** @var string  */
    private string $orderBy = 'stationId ASC';

    /** @var string  */
    private string $columns = 'stationId, sectionId, countryId, title, alias, url, publishedOn, orderBy, isFeatured, status, summary, coordinates';


    public array $response = [];

    public function all(): void
    {
        $rooms = connect()->table($this->table)->select($this->columns)->where('status', 'V')->orderBy($this->orderBy)->getAll('array');

        $this->response['type'] = 'FeatureCollection';
        foreach ($rooms as $roomId => $room) {
            $coordinates = [];
            if (!empty($room['coordinates'])) {
                $coordinates = explode(',', $room['coordinates']);
            }

            $this->response['features'][$roomId]['type'] = 'Feature';
            $this->response['features'][$roomId]['id'] = $room['stationId'];
            $this->response['features'][$roomId]['geometry']['type'] = 'Point';
            $this->response['features'][$roomId]['geometry']['coordinates'] = $coordinates;
            $this->response['features'][$roomId]['properties']['balloonContent'] = '<h3>' . $room['title'] . '</h3> <p>' . $room['alias'] . '<br><br>' . $room['summary'] . '</p>';
            $this->response['features'][$roomId]['properties']['id'] = $room['stationId'];
            $this->response['features'][$roomId]['properties']['sort'] = $room['countryId'];
        }
    }
}