<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

function smarty_function_fetch_favorite($params, &$smarty){
	
	$assign        = fetch_getParam('assign', $params, 'favorites');
    $fields        = fetch_getParam('fields', $params, 'productId, sectionId, publishedOn, title, alias, url, summary, isFeatured, special, brand, price, old_price, sku, ikpu, quantity, counter, rating, votes, stock_status_id');

	$limit         = (int) fetch_getParam('limit', $params, 100);
    $productIds  = fetch_getParam('favorites', $params);
    $userId    = (int) fetch_getParam('userId', $params);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_favorite: "assign" must not be empty');
		return;
	}

	if (!empty($userId) && $userId > 0) {
        $productIds = connect()->table('users')->select('favorites')->where('userId', $userId)->getValue();
    }
    $productIds = explode(',', $productIds);

    $products = [];
    if (!empty($productIds)) {
        if ($products = connect()->table('products')->select($fields)->in('productId', $productIds)->limit($limit)->getAll('array')) {
//            print_r($products);
            foreach ($products as $productId => $product) {
                $products[$productId] = prepareProduct($product);
                $products[$productId]['features'] = getProductFeatureValues($product['productId']);
                $products[$productId]['brand'] = getProductBrand($product['brand']);
            }
        }
	}

//    print_r($favorites);

    $smarty->assign($assign, $products);

    return null;

}

?>