<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\Uploads\ImageSizes;
use Mnv\Core\Utilities\Cookie\Session;

function smarty_function_fetch_orders($params, &$smarty) {
	
	$assign               = fetch_getParam('assign', $params, 'orders');
    $fields        = fetch_getParam('fields', $params, 'order_id, createdBy, payment_method, amount, order_status_id, name AS order_status_name');
    $userId        = fetch_getParam('user', $params, );
    $status        = fetch_getParam('status', $params, 'V');
    $limit         = (int) fetch_getParam('limit', $params);

    $image        = fetch_getParam('image', $params, false);
    $imageType    = fetch_getParam('imageType', $params, 'general');

    $sectionInfo  = fetch_getParam('sectionInfo', $params, false);
    $parentsInfo  = fetch_getParam('parentsInfo', $params, false);

	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_orders: "assign" must not be empty');
		return;
	}

	if (!empty($userId)) {
        $data = [];
        $orders = connect('shop_orders')->usingJoin('shop_order_status', 'order_status_id')->select($fields)->where('userId', $userId)->orderBy('createdBy DESC')->getAll('array');
        if (!empty($orders)) {
            $data = collect($orders)->map(function ($item) use ($sectionInfo, $parentsInfo, $image, $imageType) {
                $products = connect('shop_order_product AS sop')->join('products AS p', 'productId', '=', 'product_id')
                    ->select('sop.order_id, p.productId, sop.name, p.title, p.url, sop.brand, sop.price, sop.quantity, sop.total, sop.order_product_id')
                    ->where('order_id', $item['order_id'])->getAll('array');
//                $products = prepareProducts($products, $sectionInfo,$parentsInfo, $image, $imageType);
//                print_r($products);
                foreach ($products as $product) {
                    $product = prepareProduct($product);
                    $options = connect('shop_order_option')->select('name, value')->where('order_id', $item['order_id'])->where('order_product_id', $product['order_product_id'])->getAll('array');
                    $item['products'][] = array(
                        'url'        => $product['url'],
                        'brand'      => $product['brand'],
                        'name'       => $product['title'],
                        'image'      => $product['image'],
                        'price'      => $product['price'],
                        'quantity'   => $product['quantity'],
                        'total'      => $product['total'],
                        'options'    => $options
                    );
                }
                return $item;
            })->all();
        }

//        print_r($data);
        $smarty->assign($assign, $data);

    }

	return null;

}

//function firstElement($params = array())
//{
//    if(!is_array($params)) {
//        return false;
//    }
//    return reset($params);
//}
//
//function sortBySortOptions(&$a, &$b) {
//    return ($a['order'] < $b['order']) ? -1 : 1;
//}
?>