<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/


function smarty_function_fetch_products_count($params, &$smarty) {

	$assign        = fetch_getParam('assign', $params, 'products');
	$fields        = fetch_getParam('fields', $params, 'stock_status_id');
	$status        = fetch_getParam('status', $params, 'V');

	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_products_count: "assign" must not be empty');
		return;
	}

    /** calculate product popularity product fields */
    fetch_products_calculatePopularity($orderBy);
    /** query conditions */
    fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_articles_addSectionConditions($section, $noSubsections);
    /** skipping articles */
    fetch_products_addSkipConditions($skip);
    /** checking article fields */
    fetch_products_filterFields($fields);

    /** conditions */
	$products = connect('products')->count('productId', 'count')->select($fields)->where('status', $status)->groupBy('stock_status_id')->orderBy('stock_status_id ASC')->getAll('array');

//     print_r($products);
    $smarty->assign($assign, $products);


	return null;
}


?>