<?php


use Mnv\Core\Config;
use Mnv\Modules\Stations;

include '../includes/visitor.inc.php';

$rewrite    = request()->get('rewrite');
if ($rewrite != Config::getValue('rewrite')) {
    header("HTTP/1.0 301 Moved Permanently");
    header("Location: " . SITE_URL);

    exit;
}


$dealers = new Stations();
$dealers->all();

return response()->json($dealers->response, \Mnv\Http\Response::HTTP_OK, [
    'Access-Control-Allow-Origin' => '*',
    'Access-Control-Allow-Headers' => '*', // Accept
    'Access-Control-Request-Method' => 'OPTIONS',
    'Access-Control-Allow-Credentials' => true,
//            'Access-Control-Max-Age' => 3600,
    'Content-Type' => 'application/json;charset=UTF-8',
    'Charset' => 'utf-8'
], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();