<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}

</head>

<body>

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}
<header class="header">

	<div class="header__item">
		<div class="flex:col-max">

			<div class="header__item-inner">
				{logo link=true classLink="header__logo logo"}

				<div class="header__contacts">
					<ul>
						<li><span>Адрес:</span> {$config.address}</li>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}"><span>Тел:</span> {$phone|format_phone}</a></li>
						{/foreach}
					</ul>
				</div>

				<div class="header__lang">
					<ul>
                        <li><span>Ru</span></li>
						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
                        {* <li><a href="{$GLOBAL_URL}/en/">En</a></li> *}
					</ul>
				</div>

				<button class="header__btn header-btn_js">
                    <span class="burger-btn burger-btn_short">
                        <span class="burger-btn__item"></span>
                    </span>
				</button>

			</div>

		</div>
	</div>

	<div class="header__item">
		<div class="flex:col-max">

			<div class="header__item-inner">
				<nav class="header__nav">
					<ul>
						{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							{if isset($headerMenu.children)}
								<li>
									<button>{$headerMenu.alias}</button>

									<div class="header__nav-drop">
										<ul>
											{fetch_sections assign=subHeaderMenus from=$headerMenu.sectionId status="V"}
											{foreach item=subHeaderMenu from=$subHeaderMenus name=subHeaderMenus}
												<li><a href="{if !empty($subHeaderMenu.externalLink)}{$subHeaderMenu.externalLink}{else}{$SITE_URL}{$subHeaderMenu.url}{/if}">{$subHeaderMenu.name}</a></li>
											{/foreach}
										</ul>
									</div>
								</li>
							{else}
								<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
							{/if}

						{/foreach}
					</ul>
				</nav>
			</div>

		</div>
	</div>

	<div class="header-mob header-mob_js">
		<div class="header-mob__inner">

			<div class="header-mob__head">
				{logo link=true classLink="logo"}

				<div class="header__lang">
					<ul>
						<li><span>Ru</span></li>
						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
                        {* <li><a href="{$GLOBAL_URL}/en/">En</a></li> *}
					</ul>
				</div>
			</div>

			<div class="header-mob__content">

				<nav class="header-mob__nav">

					<ul>
						{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							{if isset($headerMenu.children)}
								<li>
									<button>{$headerMenu.alias}</button>
									<ul>
										{fetch_sections assign=subHeaderMenus from=$headerMenu.sectionId status="V"}
										{foreach item=subHeaderMenu from=$subHeaderMenus name=subHeaderMenus}
											<li><a href="{if !empty($subHeaderMenu.externalLink)}{$subHeaderMenu.externalLink}{else}{$SITE_URL}{$subHeaderMenu.url}{/if}">{$subHeaderMenu.name}</a></li>
										{/foreach}
									</ul>
								</li>
							{else}
								<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
							{/if}
						{/foreach}
					</ul>
				</nav>

			</div>

			<div class="header-mob__footer">
				<div class="header__contacts">
					<ul>
						<li><span>Адрес:</span> {$config.address}</li>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}"><span>Тел:</span> {$phone|format_phone}</a></li>
						{/foreach}
					</ul>
				</div>
			</div>

		</div>
	</div>

</header>