{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">
	{* слайдер *}
	{include file="modules/slider.tpl"}
	{* /слайдер *}

	{* Об Ассоциации *}
	{fetch_section assign=aboutSection section=7 getContent=true}{if $aboutSection.status eq 'V'}
		<section class="flex:col pad-tb-70">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-50">
					<div class="text-tmp title-48 title-accent title-tt-up"><h2>{$aboutSection.name}</h2></div>
					<div class="text-tmp txt-18 fr-2 g-gap-40 max-w-1300">{$aboutSection.content|page_break:0 nofilter}</div>

					{fetch_sections assign=associations sections=[8,9,10] status="V" image=true imageType="gallery"}{if !empty($associations)}
						<div class="grid:fr-1">
							{foreach item=association from=$associations name=associations}
							<a class="assoc-link" href="{$SITE_URL}{$association.url}">
								<div class="assoc-link__info">
									<div class="text-tmp title-36 color-white"><h3>{$association.name}</h3></div>
								</div>
								{if !empty($association.gallery)}
									{assign var=banner value=$association.gallery|element:'position':'banner'}
									{if !empty($banner)}
										<div class="assoc-link__img">
											<img src="{$banner.original}" alt="{$banner.title}"/>
										</div>
									{/if}
								{/if}
							</a>
							{/foreach}
						</div>
					{/if}
				</div>
			</div>
		</section>
	{/if}
	{* /Об Ассоциации *}

	{* Новости *}
	{fetch_section assign=newsSection section=5 getContent=true}{if $newsSection.status eq 'V'}
	<section class="flex:col pad-tb-70">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-50">

				<div class="text-tmp title-48 title-accent title-tt-up">
					<h2>{$newsSection.name}</h2>
				</div>
				{fetch_articles limit=4 assign=news image=true section=$newsSection.sectionId order="publishedOn DESC" sectionInfo=true}
				<div class="grid:fr-1 g-gap-40 mob-fr-2">
					{* news items *}
					{include file="items/news.tpl" type="gorizontal"}
					{* /news items *}
				</div>

				<a class="btn accent transparent large" href="{$SITE_URL}{$newsSection.url}">Все новости</a>
			</div>
		</div>
	</section>
	{/if}
	{* /Новости *}

	{* Публикации ассоциации *}
	{fetch_section assign=publicationSection section=4 getContent=true}{if $publicationSection.status eq 'V'}
	<section class="flex:col pad-tb-70">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-50">

				<div class="text-tmp title-48 title-accent title-tt-up">
					<h2>{$publicationSection.name}</h2>
				</div>

				{fetch_articles limit=4 assign=news image=true section=$publicationSection.sectionId order="publishedOn DESC" sectionInfo=true}
				<div class="grid:fr-1 g-gap-40 mob-fr-2">
					{* news items *}
					{include file="items/news.tpl" type="gorizontal"}
					{* /news items *}
				</div>

				<a class="btn accent transparent large" href="{$SITE_URL}{$publicationSection.url}">Все публикации</a>
			</div>
		</div>
	</section>
	{/if}
	{* /Новости *}

</main>


{include file="footer.tpl"}





