{strip}
    {fetch_banners assign=banners limit=10 section=$section.sectionId}
    {if !empty($banners)}
		<section class="flex:col">
			<div class="intro">
				<div class="swiper intro-slider_js">
					<div class="swiper-wrapper">
						{foreach item=banner from=$banners name=banners}
							<div class="swiper-slide">
								<div class="intro__item">
									<div class="intro__item-bg" data-swiper-parallax="90%">
										<picture>
											<source srcset="{$banner.images.medium}" media="(max-width: 550px)" />
											<source srcset="{$banner.images.medium}" media="(max-width: 768px)" />
											<source srcset="{$banner.images.large}" media="(max-width: 1024px)" />
											<source srcset="{$banner.images.original}" media="(max-width: 1440px)" />
											<img src="{$banner.images.original}" alt="{$banner.title nofilter}" />
										</picture>
									</div>

									<div class="intro__item-info" data-swiper-parallax="400">
										<div class="flex:col-max">
											<div class="intro__item-info-content">
												<div class="text-tmp title-48 color-white txt-ff-s txt-22 txt-tt-up">
													{if $smarty.foreach.banners.first}
														<h1>{$banner.title nofilter}</h1>
													{else}
														<h2>{$banner.title nofilter}</h2>
													{/if}
													{if !empty($banner.alias)}<p>{$banner.alias nofilter}</p>{/if}
												</div>

												{if !empty($banner.url)}
													<a class="btn white large  transparent" href="{$SITE_URL}{$banner.url}">Подробнее</a>
												{/if}
											</div>
										</div>
									</div>
								</div>
							</div>
						{/foreach}
					</div>
				</div>

				<div class="intro__arrows">
					<div class="flex:col-max">

						<div class="intro__arrows-inner">
							<button class="intro__arrow intro-prev_js">
								<svg width="102" height="22" viewBox="0 0 102 22" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M11.293 0.292969L12.7073 1.70718L4.41436 10.0001H102V12.0001H4.41436L12.7073 20.293L11.293 21.7072L0.585938 11.0001L11.293 0.292969Z" fill="white" />
								</svg>
							</button>

							<button class="intro__arrow intro-next_js">
								<svg width="102" height="22" viewBox="0 0 102 22" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" clip-rule="evenodd" d="M90.707 0.292969L89.2927 1.70718L97.5856 10.0001H-0.000152588V12.0001H97.5856L89.2927 20.293L90.707 21.7072L101.414 11.0001L90.707 0.292969Z" fill="white" />
								</svg>
							</button>
						</div>

					</div>
				</div>

			</div>
		</section>
    {/if}
{/strip}